﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace HospitalStateWorkflow
{
    [Serializable]
	class AppointmentManager : IAppointment
	{
        public event EventHandler<AppointmentEventArgs> PatientArrived;
        public event EventHandler<AppointmentEventArgs> PaperworkDone;
        public event EventHandler<AppointmentEventArgs> DoctorReady;
        public event EventHandler<AppointmentEventArgs> AppointmentComplete;

        public void DoPaperwork(Guid instanceID, string name)
        {
            PatientArrived(
                this,
                new AppointmentEventArgs(instanceID)
                {
                    PatientName = "Jaś"
                });
        }

        public void Wait(Guid instanceID, string name)
        {
            PaperworkDone(
                this,
                new AppointmentEventArgs(instanceID)
                    {
                        PatientName = name
                    });
        }

        public void SeeDoctor(Guid instanceID, string name)
        {
            DoctorReady(
                this,
                new AppointmentEventArgs(instanceID)
                {
                    PatientName = name
                });
        }

        public void GoHome(Guid instanceID, string name)
        {
            AppointmentComplete(
                this,
                new AppointmentEventArgs(instanceID)
                {
                    PatientName = name
                });
        }
    }
}
